﻿(function () {
    var app = angular.module('homeControl', ['ngConstellation']);

    app.controller('ShutterAngularController', ['$scope', 'constellation', function ($scope, constellation) {

        $scope.objectsState = {};

        constellation.intializeClient("http://constellation.xxxxxxx:8088/", "xxxxxxxx", "HomeControl");


        constellation.onUpdateStateObject(function (message) {
            $scope.$apply(function () {
                //console.log(message);
                if (typeof $scope[message.PackageName] === 'undefined' || $scope[message.PackageName] === null) {
                    $scope[message.PackageName] = {};
                }
                $scope[message.PackageName][message.Name] = message;
            });
        });

        constellation.onConnectionStateChanged(function (change) {
            console.log(change.newState);
            if (change.newState === $.signalR.connectionState.connected) {
                constellation.requestSubscribeStateObjects("*", "ShutterController", "*", "*");
            }
        });

        $scope.Test = function (shutter) {
            console.log(shutter);
        };

        $scope.actionShutter = function (shutter, action) {
            constellation.sendMessage({ Scope: 'Package', Args: ['ShutterController'] }, 'ActionVoletMessageCallback', { 'shutterName': shutter.Name, 'actionShutter': action });
        };

        constellation.connect();

    }]);

})();









